<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// DB credentials
$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

// Connect to database
$conn = new mysqli($host, $user, $pass, $db);

// Check connection
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed."
    ]);
    exit;
}

// Get raw input and decode JSON
$input = json_decode(file_get_contents("php://input"), true);
$menu_id = $input['id'] ?? 0;

// Validate input
if (!$menu_id) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid menu ID."
    ]);
    exit;
}

// Prepare and execute DELETE query
$stmt = $conn->prepare("DELETE FROM menu WHERE id = ?");
$stmt->bind_param("i", $menu_id);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Menu item deleted successfully."
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to delete menu item."
    ]);
}

// Cleanup
$stmt->close();
$conn->close();
?>
