<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed."]);
    exit;
}

$id = $_GET['id'] ?? 0;

if (!$id) {
    echo json_encode(["success" => false, "message" => "Menu ID is required."]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM menu WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["success" => true, "menu" => $row]);
} else {
    echo json_encode(["success" => false, "message" => "Menu item not found."]);
}

$stmt->close();
$conn->close();
?>
