<?php
header('Content-Type: application/json');

// Check if restaurant_id is provided
if (!isset($_GET['restaurant_id'])) {
    echo json_encode(['error' => 'restaurant_id parameter is required']);
    exit;
}

$restaurant_id = intval($_GET['restaurant_id']);

require 'db.php'; // Your database connection file

try {
    $stmt = $pdo->prepare('SELECT id, restaurant_id, name, price FROM menus WHERE restaurant_id = ?');
    $stmt->execute([$restaurant_id]);
    $menus = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($menus) === 0) {
        echo json_encode(['message' => 'No menus found for this restaurant', 'menus' => []]);
    } else {
        echo json_encode(['menus' => $menus]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
}
