<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Join menu and restaurants table to get restaurant name
$sql = "
    SELECT 
        menu.*,
        restaurants.name AS restaurant_name
    FROM 
        menu
    LEFT JOIN 
        restaurants ON menu.restaurant_id = restaurants.id
";

$result = $conn->query($sql);

if (!$result) {
    echo json_encode(["success" => false, "message" => "Query failed: " . $conn->error]);
    exit;
}

$menus = [];
while ($row = $result->fetch_assoc()) {
    $menus[] = $row;
}

echo json_encode(["success" => true, "menu" => $menus]);

$conn->close();
?>