<?php
include 'db.php'; // Your DB connection

$data = json_decode(file_get_contents("php://input"), true);
$email = $data['email'];
$password = $data['password'];

$response = [];

$stmt = $conn->prepare("SELECT * FROM restaurants WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
  $restaurant = $result->fetch_assoc();
  if (password_verify($password, $restaurant['password'])) {
    $response['success'] = true;
    $response['restaurant'] = [
      'id' => $restaurant['id'],
      'name' => $restaurant['name'],
      'email' => $restaurant['email'],
      'phone' => $restaurant['phone'],
      'address' => $restaurant['address']
    ];
  } else {
    $response['success'] = false;
    $response['message'] = "Incorrect password";
  }
} else {
  $response['success'] = false;
  $response['message'] = "Restaurant not found";
}

echo json_encode($response);
?>
