<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");

$conn = new mysqli("localhost", "root", "", "quickcrusine");

$data = json_decode(file_get_contents("php://input"), true);
$email = $data['email'];
$password = $data['password'];

$stmt = $conn->prepare("SELECT id, name, email, password FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
  if (password_verify($password, $row['password'])) {
    echo json_encode([
      "success" => true,
      "user" => [
        "id" => $row['id'],
        "name" => $row['name'],
        "email" => $row['email']
      ]
    ]);
  } else {
    echo json_encode(["success" => false, "message" => "Invalid password."]);
  }
} else {
  echo json_encode(["success" => false, "message" => "User not found."]);
}
