<?php
require 'db.php';

// Get restaurant_id from query params
$restaurant_id = $_GET['restaurantId'] ?? null;

header('Content-Type: application/json');

// Simple router by HTTP method
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    if (!$restaurant_id) {
        echo json_encode(['success' => false, 'message' => 'restaurantId required']);
        exit;
    }
    $stmt = $pdo->prepare("SELECT * FROM menu");
    $stmt->execute([$restaurant_id]);
    $menu = $stmt->fetchAll();
    echo json_encode(['success' => true, 'menu' => $menu]);
}

elseif ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $name = $data['name'] ?? '';
    $price = $data['price'] ?? 0;
    $image = $data['image'] ?? '';
    $restaurant_id = $data['restaurant_id'] ?? null;

    if (!$restaurant_id || !$name) {
        echo json_encode(['success'=>false, 'message'=>'Missing fields']);
        exit;
    }

    $stmt = $pdo->prepare("INSERT INTO menu (restaurant_id, name, price, image) VALUES (?, ?, ?, ?)");
    $stmt->execute([$restaurant_id, $name, $price, $image]);
    $id = $pdo->lastInsertId();

    $stmt = $pdo->prepare("SELECT * FROM menu WHERE id = ?");
    $stmt->execute([$id]);
    $item = $stmt->fetch();

    echo json_encode(['success'=>true, 'item'=>$item]);
}

elseif ($method === 'PUT') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        echo json_encode(['success'=>false, 'message'=>'Menu item ID required']);
        exit;
    }
    $data = json_decode(file_get_contents('php://input'), true);
    $name = $data['name'] ?? '';
    $price = $data['price'] ?? 0;
    $image = $data['image'] ?? '';

    $stmt = $pdo->prepare("UPDATE menu SET name = ?, price = ?, image = ? WHERE id = ?");
    $stmt->execute([$name, $price, $image, $id]);

    $stmt = $pdo->prepare("SELECT * FROM menu WHERE id = ?");
    $stmt->execute([$id]);
    $item = $stmt->fetch();

    echo json_encode(['success'=>true, 'item'=>$item]);
}

elseif ($method === 'DELETE') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        echo json_encode(['success'=>false, 'message'=>'Menu item ID required']);
        exit;
    }
    $stmt = $pdo->prepare("DELETE FROM menu WHERE id = ?");
    $stmt->execute([$id]);
    echo json_encode(['success'=>true]);
}
else {
    http_response_code(405);
    echo json_encode(['success'=>false, 'message'=>'Method not allowed']);
}
