<?php
// momo.php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

require 'vendor/autoload.php'; // patricpoba/mtn-momo-api-php

use PatricPoba\MtnMomo\MtnConfig;
use PatricPoba\MtnMomo\Products\Collection;

$data = json_decode(file_get_contents("php://input"), true);
$userId = $data['userId'] ?? null;
$restId = $data['restaurantId'] ?? null;
$cart = $data['cartItems'] ?? [];
$total = $data['total'] ?? 0;

if (!$userId || !$restId || empty($cart) || $total <= 0) {
  echo json_encode(["success"=>false,"message"=>"Missing/invalid data"]); exit;
}

// Configure MoMo
$config = new MtnConfig([
  'baseUrl' => 'https://sandbox.momodeveloper.mtn.com',
  'currency' => 'EUR',
  'targetEnvironment' => 'sandbox',
  'collectionApiSecret' => 'YOUR_COLLECTION_API_SECRET',
  'collectionPrimaryKey' => 'YOUR_PRIMARY_KEY',
  'collectionUserId' => 'YOUR_USER_ID',
]);
$collection = new Collection($config);

// 1. request to pay
$externalId = uniqid('quickc_');
$params = [
  'amount' => number_format($total,2, '.', ''),
  'currency' => 'EUR',
  'externalId' => $externalId,
  'payer' => ['partyIdType'=>'MSISDN','partyId'=>$data['phone']], // user mobile
  'payerMessage'=> 'Payment for QuickCrusine order',
  'payeeNote'=> 'Thank you!'
];

try {
  $t = $collection->requestToPay($params);
} catch (Exception $e) {
  echo json_encode(["success"=>false,"message"=>$e->getMessage()]); exit;
}

// 2. Save order to DB
$conn = new mysqli('localhost','root','','quickcrusine');
if ($conn->connect_error) {
  echo json_encode(["success"=>false,"message"=>$conn->connect_error]); exit;
}

$stmt = $conn->prepare("INSERT INTO orders (user_id,restaurant_id,total,external_id,payment_status) VALUES(?,?,?,?,?)");
$status='PENDING';
$stmt->bind_param("iids s",$userId,$restId,$total,$externalId,$status);
$stmt->execute();
$orderId = $stmt->insert_id;

$itemStmt = $conn->prepare("INSERT INTO order_items (order_id,name,quantity,price) VALUES (?,?,?,?)");
foreach ($cart as $i){
  $itemStmt->bind_param("isid",$orderId,$i['name'],$i['quantity'],$i['price']);
  $itemStmt->execute();
}

echo json_encode(["success"=>true,"orderId"=>$orderId,"message"=>"Check your phone to complete payment"]);
