<?php
require 'db.php';

header('Content-Type: application/json');
$method = $_SERVER['REQUEST_METHOD'];

$restaurant_id = $_GET['restaurantId'] ?? null;

if ($method === 'GET') {
    if (!$restaurant_id) {
        echo json_encode(['success' => false, 'message' => 'restaurantId required']);
        exit;
    }

    // Get orders related to this restaurant via menu items
    $stmt = $pdo->prepare("
        SELECT DISTINCT o.id, o.user_id, o.total_amount, o.status, o.created_at, u.name as user_name, u.email as user_email
        FROM orders o
        JOIN users u ON o.user_id = u.id
        JOIN order_items oi ON o.id = oi.order_id
        JOIN menu m ON oi.menu_id = m.id
        WHERE m.restaurant_id = ?
        ORDER BY o.created_at DESC
    ");
    $stmt->execute([$restaurant_id]);
    $orders = $stmt->fetchAll();

    // Get items for each order
    foreach ($orders as &$order) {
        $stmt2 = $pdo->prepare("
            SELECT oi.id, oi.quantity, m.name, m.price, m.image
            FROM order_items oi
            JOIN menu m ON oi.menu_id = m.id
            WHERE oi.order_id = ?
        ");
        $stmt2->execute([$order['id']]);
        $order['items'] = $stmt2->fetchAll();
    }

    echo json_encode(['success' => true, 'orders' => $orders]);
}

elseif ($method === 'PUT') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        echo json_encode(['success'=>false, 'message'=>'Order ID required']);
        exit;
    }

    $data = json_decode(file_get_contents('php://input'), true);
    $status = $data['status'] ?? null;
    if (!$status) {
        echo json_encode(['success'=>false, 'message'=>'Status required']);
        exit;
    }

    $stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?");
    $stmt->execute([$status, $id]);

    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$id]);
    $order = $stmt->fetch();

    echo json_encode(['success'=>true, 'order'=>$order]);
}

else {
    http_response_code(405);
    echo json_encode(['success'=>false, 'message'=>'Method not allowed']);
}
