<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["success" => false, "message" => "Invalid JSON input."]);
    exit;
}

$userId = $data['userId'] ?? null;
$restaurantId = $data['restaurantId'] ?? null;
$cartItems = $data['cartItems'] ?? [];
$total = $data['total'] ?? 0;

if (!$userId || !$restaurantId || empty($cartItems)) {
    echo json_encode(["success" => false, "message" => "Missing required data."]);
    exit;
}

$conn = new mysqli("localhost", "root", "", "quickcrusine");

if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

$sql = "INSERT INTO orders (user_id, restaurant_id, total) VALUES (?, ?, ?)";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "success" => false,
        "message" => "Prepare failed: " . $conn->error,
    ]);
    exit;
}

$stmt->bind_param("iid", $userId, $restaurantId, $total);

if ($stmt->execute()) {
    $orderId = $stmt->insert_id;

    $itemStmt = $conn->prepare("INSERT INTO order_items (order_id, name, quantity, price) VALUES (?, ?, ?, ?)");

    if (!$itemStmt) {
        echo json_encode([
            "success" => false,
            "message" => "Item prepare failed: " . $conn->error,
        ]);
        exit;
    }

    $allInserted = true;

    foreach ($cartItems as $item) {
        $itemName = $item['name'] ?? '';
        $quantity = (int)($item['quantity'] ?? 1);
        $price = (float)($item['price'] ?? 0);

        $itemStmt->bind_param("isid", $orderId, $itemName, $quantity, $price);

        if (!$itemStmt->execute()) {
            $allInserted = false;
            error_log("Item insert failed: " . $itemStmt->error);
        }
    }

    if ($allInserted) {
        echo json_encode(["success" => true, "message" => "Order and items saved successfully."]);
    } else {
        echo json_encode(["success" => false, "message" => "Order saved, but one or more items failed to insert."]);
    }

} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to save order.",
        "sql_error" => $stmt->error,
        "sql" => $sql,
        "params" => ["userId" => $userId, "restaurantId" => $restaurantId, "total" => $total]
    ]);
}

$conn->close();
?>
