<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");

// Database connection
$conn = new mysqli("localhost", "root", "", "quickcrusine");

// Check connection
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]);
    exit;
}

// Read and decode JSON input
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!$data || !isset($data['name'], $data['email'], $data['password'])) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid input or missing fields."
    ]);
    exit;
}

$name = $data['name'];
$email = $data['email'];
$password = password_hash($data['password'], PASSWORD_DEFAULT);
$phone = $data['phone'] ?? '';
$address = $data['address'] ?? '';

// Prepare SQL statement
$stmt = $conn->prepare("INSERT INTO restaurants (name, email, password, phone, address) VALUES (?, ?, ?, ?, ?)");

if (!$stmt) {
    echo json_encode([
        "success" => false,
        "message" => "Prepare failed: " . $conn->error
    ]);
    exit;
}

$stmt->bind_param("sssss", $name, $email, $password, $phone, $address);

// Execute and respond
if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Restaurant registered successfully"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Execution failed: " . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
