<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Database config
$host = "localhost";
$user = "root";
$pass = "";
$db = "quickcrusine";

// Connect
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit;
}

// Get restaurant ID from GET
$restaurant_id = isset($_GET['restaurant_id']) ? intval($_GET['restaurant_id']) : 0;

if ($restaurant_id <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid or missing restaurant_id"]);
    exit;
}

// Query the menu
$sql = "SELECT id, name, price, image FROM menu WHERE restaurant_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $restaurant_id);
$stmt->execute();
$result = $stmt->get_result();

$menu = [];
while ($row = $result->fetch_assoc()) {
    $menu[] = $row;
}

echo json_encode([
    "success" => true,
    "menu" => $menu
]);

$stmt->close();
$conn->close();
?>
