<?php
// Enable CORS and JSON header
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

// Load Stripe SDK
require 'vendor/autoload.php';
\Stripe\Stripe::setApiKey('sk_test_51RTJv3RgaHMsVsy0sbaomyXS9SbggWkfo3a3RD8KBhcmlxgt0bIDCGjWjQanxnxoUM7egX4RPIRXSJuMeQGVjiqP005PSCsCtw');

// Parse incoming request
$data = json_decode(file_get_contents("php://input"), true);

$userId = $data['userId'] ?? null;
$restaurantId = $data['restaurantId'] ?? null;
$cartItems = $data['cartItems'] ?? [];
$total = $data['total'] ?? 0;

if (!$userId || !$restaurantId || empty($cartItems) || $total <= 0) {
    echo json_encode(["success" => false, "message" => "Missing or invalid data."]);
    exit;
}

// Step 1: Create PaymentIntent
try {
    $paymentIntent = \Stripe\PaymentIntent::create([
        'amount' => intval($total * 100), // amount in cents
        'currency' => 'usd',
        'metadata' => [
            'user_id' => $userId,
            'restaurant_id' => $restaurantId
        ],
        'automatic_payment_methods' => ['enabled' => true],
    ]);
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(["success" => false, "message" => "Stripe Error: " . $e->getMessage()]);
    exit;
}

// Step 2: Save to MySQL
$conn = new mysqli("localhost", "root", "", "quickcrusine");
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "DB Connection failed: " . $conn->connect_error]);
    exit;
}

$orderSql = "INSERT INTO orders (user_id, restaurant_id, total, stripe_payment_id) VALUES (?, ?, ?, ?)";
$stmt = $conn->prepare($orderSql);
if (!$stmt) {
    echo json_encode(["success" => false, "message" => "Prepare failed: " . $conn->error]);
    exit;
}
$stripeId = $paymentIntent->id;
$stmt->bind_param("iids", $userId, $restaurantId, $total, $stripeId);

if ($stmt->execute()) {
    $orderId = $stmt->insert_id;

    $itemStmt = $conn->prepare("INSERT INTO order_items (order_id, name, quantity, price) VALUES (?, ?, ?, ?)");
    if (!$itemStmt) {
        echo json_encode(["success" => false, "message" => "Item prepare failed: " . $conn->error]);
        exit;
    }

    foreach ($cartItems as $item) {
        $itemName = $item['name'] ?? '';
        $quantity = (int)($item['quantity'] ?? 1);
        $price = (float)($item['price'] ?? 0);
        $itemStmt->bind_param("isid", $orderId, $itemName, $quantity, $price);
        $itemStmt->execute(); // Ignore individual failures to insert
    }

    echo json_encode([
        "success" => true,
        "message" => "PaymentIntent created and order saved.",
        "clientSecret" => $paymentIntent->client_secret,
        "paymentIntentId" => $paymentIntent->id,
        "orderId" => $orderId,
        "cartItems" => $cartItems, // Pass items back to ReceiptScreen
        "total" => $total
    ]);
} else {
    echo json_encode(["success" => false, "message" => "Order insert failed.", "error" => $stmt->error]);
}

$conn->close();
?>
