<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");

$host = "localhost";
$db = "quickcrusine";
$user = "root";
$pass = "";

// Create connection
$conn = new mysqli($host, $user, $pass, $db);

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Database connection failed."]);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents("php://input"), true);
$email = $input['email'] ?? '';
$password = $input['password'] ?? '';
$accountType = $input['accountType'] ?? 'user';

// Validate input
if (empty($email) || empty($password)) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Email and password are required."]);
    exit;
}

// Whitelist allowed account types
$allowedTypes = ['user', 'restaurant'];
if (!in_array($accountType, $allowedTypes)) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid account type."]);
    exit;
}

// Select table based on account type
$table = $accountType === 'restaurant' ? 'restaurants' : 'users';

// Prepare and execute SQL
$stmt = $conn->prepare("SELECT * FROM `$table` WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$userData = $result->fetch_assoc();

if ($userData) {
    // Verify hashed password
    if (password_verify($password, $userData['password'])) {
        unset($userData['password']); // Don't send password back
        $userData['accountType'] = $accountType;
        echo json_encode(["success" => true, "user" => $userData]);
    } else {
        echo json_encode(["success" => false, "message" => "Invalid password."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "User not found."]);
}

// Close resources
$stmt->close();
$conn->close();
?>
