<?php
// Include the db connection
require_once 'db.php';

// Test DB connectivity with a simple query (optional but useful)
try {
    $stmt = $pdo->query('SELECT 1');
    if ($stmt !== false) {
        echo "<h2 style='color: green;'>✅ Database connection and query test successful!</h2>";
    } else {
        echo "<h2 style='color: orange;'>⚠️ Connected, but query test failed.</h2>";
    }
} catch (PDOException $e) {
    echo "<h2 style='color: red;'>❌ Connected, but test query failed:</h2>";
    echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
}
?>
